package coreservlets.listeners;

import java.util.*;

import javax.servlet.*;

/** Proces nasuchujcy, ktry konfiguruje ustawienia
 *  dla mechanizmu ledzenia zamwie na oferty dnia.
 *  Proces odczytuje z parametrw inicjalizacyjnych 
 *  list nazw atrybutw; odpowiadaj one atrybutom sesji,
 *  za pomoc ktrych rejestrowane s zamwienia.
 *  Proces odczytuje rwnie list nazw towarw; odpowiadaj one
 *  nazwom towarw oferowanych w ramach oferty dnia. Pozostae
 *  procesy nasuchujce bd sprawdza, czy wartoci atrybutw,
 *  ktre zostay wskazane jako odpowiadajce zamwieniom,
 *  wskazuj towary bdce ofertami dnia.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class DailySpecialRegistrar
    implements ServletContextListener {

  /** W momencie adowania aplikacji internetowej zapisywane s
   *  nazwy atrybutw odpowiadajcych zamwieniom 
   *  wartoci atrybutw wskazujce oferty dnia.
   *  Ponadto licznikowi zamwie na oferty dnia
   *  przypisywana jest warto zero.
   */
  public void contextInitialized(ServletContextEvent event) {
    ServletContext context = event.getServletContext();
    addContextEntry(context, "order-attribute-names");
    addContextEntry(context, "daily-special-item-names");
    context.setAttribute("dailySpecialCount", new Integer(0));
  }

  public void contextDestroyed(ServletContextEvent event) {}

  /** Odczytanie parametru inicjalizacyjnego kontekstu,
   *  umieszczenie wartoci w ArrayList i zapisanie listy
   *  w kontekcie serwletu ServletContext wraz z nazw atrybutu,
   *  ktra jest identyczna jak nazwa parametru inicjalizacyjnego.
   */
  private void addContextEntry(ServletContext context,
                               String initParamName) {
    ArrayList<String> paramValues = new ArrayList<String>();
    String attributeNames =
      context.getInitParameter(initParamName);
    if (attributeNames != null) {
      String[] params = attributeNames.split("\\s++");
      for (String value : params) {
        paramValues.add(value);
      }
      context.setAttribute(initParamName, paramValues);
    }
  }

  /** Zwrcenie cigu znakw zawierajcego nazwy towarw
   *  bdcych ofertami dnia. Cig do wstawienia w kodzie 
   *  HTML strony.
   */
  public static String dailySpecials(ServletContext context) {
    String attributeName = "daily-special-item-names";
    ArrayList itemNames =
      (ArrayList)context.getAttribute(attributeName);
    String itemString = "";
    for(int i=0; i<itemNames.size(); i++) {
      itemString = itemString + (String)itemNames.get(i) + "\n";
    }
    return(itemString);
  }

  /** Zwrcenie listy zawierajcej nazwy towarw-ofert dnia.
   *  Lista do wstawienia w treci strony JSP.
   */
  public static String specialsList(ServletContext context) {
    String attributeName = "daily-special-item-names";
    ArrayList itemNames =
      (ArrayList)context.getAttribute(attributeName);
    String itemString = "<UL>\n";
    for(int i=0; i<itemNames.size(); i++) {
      itemString = itemString + "<LI>" +
                   (String)itemNames.get(i) + "\n";
    }
    itemString = itemString + "</UL>";
    return(itemString);
  }
}
